/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.rendering.data.attachment.client;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.fabricmc.fabric.impl.rendering.data.attachment.RenderDataObjectConsumer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_6850;
import net.minecraft.class_853;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_6850.class})
public abstract class MixinChunkRendererRegionBuilder {
    private static final AtomicInteger ERROR_COUNTER = new AtomicInteger();
    private static final Logger LOGGER = LoggerFactory.getLogger(MixinChunkRendererRegionBuilder.class);

    @Inject(at={@At(value="RETURN")}, method={"build"}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void create(class_1937 world, class_2338 startPos, class_2338 endPos, int chunkRadius, CallbackInfoReturnable<class_853> info, int i, int j, int k, int l, class_6850.class_6851[][] chunkData) {
        Long2ObjectOpenHashMap<Object> map = null;
        class_6850.class_6851[][] class_6851Array = chunkData;
        int n = class_6851Array.length;
        for (int i2 = 0; i2 < n; ++i2) {
            class_6850.class_6851[] chunkDataOuter;
            block3: for (class_6850.class_6851 data : chunkDataOuter = class_6851Array[i2]) {
                while (true) {
                    try {
                        map = MixinChunkRendererRegionBuilder.mapChunk(data.method_39971(), startPos, endPos, map);
                        continue block3;
                    }
                    catch (ConcurrentModificationException e) {
                        int count = ERROR_COUNTER.incrementAndGet();
                        if (count > 5) continue;
                        LOGGER.warn("[Render Data Attachment] Encountered CME during render region build. A mod is accessing or changing chunk data outside the main thread. Retrying.", (Throwable)e);
                        if (count != 5) continue;
                        LOGGER.info("[Render Data Attachment] Subsequent exceptions will be suppressed.");
                        continue;
                    }
                    break;
                }
            }
        }
        class_853 rendererRegion = (class_853)info.getReturnValue();
        if (map != null && rendererRegion != null) {
            ((RenderDataObjectConsumer)rendererRegion).fabric_acceptRenderDataObjects(map);
        }
    }

    private static Long2ObjectOpenHashMap<Object> mapChunk(class_2818 chunk, class_2338 posFrom, class_2338 posTo, Long2ObjectOpenHashMap<Object> map) {
        int xMin = posFrom.method_10263();
        int xMax = posTo.method_10263();
        int zMin = posFrom.method_10260();
        int zMax = posTo.method_10260();
        int yMin = posFrom.method_10264();
        int yMax = posTo.method_10264();
        for (Map.Entry entry : chunk.method_12214().entrySet()) {
            Object o;
            class_2338 entPos = (class_2338)entry.getKey();
            if (entPos.method_10263() < xMin || entPos.method_10263() > xMax || entPos.method_10264() < yMin || entPos.method_10264() > yMax || entPos.method_10260() < zMin || entPos.method_10260() > zMax || (o = ((RenderAttachmentBlockEntity)entry.getValue()).getRenderAttachmentData()) == null) continue;
            if (map == null) {
                map = new Long2ObjectOpenHashMap();
            }
            map.put(entPos.method_10063(), o);
        }
        return map;
    }
}

